/**
* \file: TouchListener.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Digital iPod Out - Wayland Adapter
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <dipo_plugin.h>
#include "TouchListener.h"

LOG_IMPORT_CONTEXT(dipo_wl);

namespace adit { namespace carplay
{

using namespace std;

struct wl_touch_listener TouchListener::Listener =
{
    TouchListener::handleDown,
    TouchListener::handleUp,
    TouchListener::handleMotion,
    TouchListener::handleFrame,
    TouchListener::handleCancel,
    NULL,
    NULL
};

TouchListener::TouchListener(IInputReceiver& inReceiver, HIDDigitizer& inDigitizer, int inWidth,
        int inHeight, bool inVerbose) :
        receiver(inReceiver), hid(inDigitizer)
{
    x = 0;
    y = 0;

    width = inWidth;
    height = inHeight;
    verbose = inVerbose;
}

TouchListener::~TouchListener()
{
    // do nothing
}

void TouchListener::handleDown(void* inData, struct wl_touch* inTouch, uint32_t inSerial,
        uint32_t inTime, struct wl_surface* inSurface, int32_t inID, wl_fixed_t inX, wl_fixed_t inY)
{
    (void)inTouch;
    (void)inSerial;
    (void)inTime;
    (void)inSurface;

    auto me = static_cast<TouchListener*>(inData);

    me->x = (float)wl_fixed_to_double(inX) / me->width;
    me->y = (float)wl_fixed_to_double(inY) / me->height;

    // touch down
    if (me->verbose)
    {
        LOGD_VERBOSE((dipo_wl, "TouchListener touch down at %.3fx%.3f id:%d", me->x, me->y, inID));
    }
    HIDInputReportWithData report;
    if (me->hid.Down(me->x, me->y, inID, report))
        me->receiver.SendInput(report.report);
}

void TouchListener::handleUp(void* inData, struct wl_touch* inTouch, uint32_t inSerial,
        uint32_t inTime, int32_t inID)
{
    (void)inData;
    (void)inTouch;
    (void)inSerial;
    (void)inTime;

    auto me = static_cast<TouchListener*>(inData);

    // touch up
    if (me->verbose)
    {
        LOGD_VERBOSE((dipo_wl, "TouchListener touch up id:%d", inID));
    }
    HIDInputReportWithData report;
    if (me->hid.Up(inID, report))
        me->receiver.SendInput(report.report);
}

void TouchListener::handleMotion(void* inData, struct wl_touch* inTouch, uint32_t inTime,
        int32_t inID, wl_fixed_t inX, wl_fixed_t inY)
{
    (void)inData;
    (void)inTouch;
    (void)inTime;

    auto me = static_cast<TouchListener*>(inData);

    me->x = (float)wl_fixed_to_double(inX) / me->width;
    me->y = (float)wl_fixed_to_double(inY) / me->height;

    // touch motion
    HIDInputReportWithData report;
    if (me->hid.Down(me->x, me->y, inID, report))
        me->receiver.SendInput(report.report);
}

void TouchListener::handleFrame(void* inData, struct wl_touch* inTouch)
{
    (void)inData;
    (void)inTouch;

    // do nothing
}

void TouchListener::handleCancel(void* inData, struct wl_touch* inTouch)
{
    (void)inData;
    (void)inTouch;

    // do nothing
}

} } // namespace adit { namespace carplay
